/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.item;

import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.platform.IPlatformHelper;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LexiconItem
extends Item {
    private static final String URL = "https://github.com/tristankechlo/Living-Things/wiki";

    public LexiconItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            if (IPlatformHelper.INSTANCE.isModLoaded("patchouli")) {
                ResourceLocation book = BuiltInRegistries.f_257033_.m_7981_((Object)ModItems.LEXICON.get());
                IPlatformHelper.INSTANCE.openBookGui(player, book);
            } else {
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237115_((String)"messages.livingthings.nopatchouli.title")));
                player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237115_((String)"messages.livingthings.nopatchouli.subtitle")));
                player.m_213846_((Component)Component.m_237110_((String)"messages.livingthings.nopatchouli.wiki", (Object[])new Object[]{URL}));
            }
        }
        ItemStack stack = playerIn.m_21120_(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        boolean patchouliLoaded = IPlatformHelper.INSTANCE.isModLoaded("patchouli");
        if (target.m_9236_().m_5776_() && patchouliLoaded && target instanceof ILexiconEntry) {
            ResourceLocation book = BuiltInRegistries.f_257033_.m_7981_((Object)ModItems.LEXICON.get());
            ResourceLocation entry = ((ILexiconEntry)target).getLexiconEntry();
            IPlatformHelper.INSTANCE.openBookEntry(book, entry, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Block block = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
        boolean patchouliLoaded = IPlatformHelper.INSTANCE.isModLoaded("patchouli");
        if (context.m_43725_().m_5776_() && patchouliLoaded && block instanceof ILexiconEntry) {
            ResourceLocation book = BuiltInRegistries.f_257033_.m_7981_((Object)ModItems.LEXICON.get());
            ResourceLocation entry = ((ILexiconEntry)block).getLexiconEntry();
            IPlatformHelper.INSTANCE.openBookEntry(book, entry, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)LexiconItem.getEdition().m_6879_().m_130940_(ChatFormatting.GRAY));
    }

    public static Component getEdition() {
        if (IPlatformHelper.INSTANCE.isModLoaded("patchouli")) {
            ResourceLocation book = BuiltInRegistries.f_257033_.m_7981_((Object)ModItems.LEXICON.get());
            return IPlatformHelper.INSTANCE.getPatchouliSubtitle(book);
        }
        return Component.m_237113_((String)"2nd Edition");
    }
}

